<?php
$db = new SQLite3("./api/data/.bet_tmdb.db");

if (isset($_POST["submit"])) {
    $images = $_POST["images"];
    $title = $_POST["title"];
    $description = $_POST["description"];

    $stmt = $db->prepare("INSERT INTO ads (images, title, description) VALUES (:images, :title, :description)");
    $stmt->bindValue(':images', $images, SQLITE3_TEXT);
    $stmt->bindValue(':title', $title, SQLITE3_TEXT);
    $stmt->bindValue(':description', $description, SQLITE3_TEXT);

    $stmt->execute();
    $stmt->close();
    
    header("Location: ads.php");
    exit;
}

include "includes/header.php";
?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ Main Content ] start -->
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white"><i class="fas fa-images" style="font-size:20px">&nbsp;&nbsp;</i>Upload AD Image</h4>
                                    </div>
                                    <div class="card-body">
                                        <form method="post">
                                            <div class="form-group">
                                                <label class="form-label" for="images"><strong>Image Url</strong></label>
                                                <input class="form-control text-primary" id="images" name="images" type="url" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="title"><strong>Title</strong></label>
                                                <input class="form-control text-primary" id="title" name="title" type="text" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="description"><strong>Description</strong></label>
                                                <textarea class="form-control text-primary" id="description" name="description" rows="4" required></textarea>
                                            </div>
                                            <div align="center" class="form-group">
                                                <br>
                                                <button class="btn btn-danger" name="submit" type="submit">
                                                    <span class="icon text-white-50"><i class="fa fa-plus"></i>&nbsp;&nbsp;</span>
                                                    <span class="text"> Upload AD Image</span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Column -->
                        </div>
                    </div>
                    <!-- ============================================================== -->
                    <!-- End Container fluid  -->
                    <!-- ============================================================== -->
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Page wrapper  -->
            <!-- ============================================================== -->
        </div>
    </div>
</div>

<?php
include "includes/functions.php";
?>
