<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);

// Database connection
$dbPath = "./api/data/.bet_tmdb.db";
$db = new SQLite3($dbPath);

if (!$db) {
    die("Database connection error: " . $db->lastErrorMsg());
}

$updateId = $_GET["update"] ?? null;

if ($updateId !== null) {
    $stmt = $db->prepare("SELECT * FROM ads WHERE id=:id");
    $stmt->bindValue(':id', $updateId, SQLITE3_INTEGER);
    $res = $stmt->execute();

    if (!$res) {
        die("Database query error: " . $db->lastErrorMsg());
    }

    $row = $res->fetchArray(SQLITE3_ASSOC);
} else {
    echo "Please provide an update ID.";
    exit(); // Exit script if no update ID is provided
}

if (isset($_POST["submit"])) {
    $id = $_POST["id"];
    $images = $_POST["images"];
    $title = $_POST["title"];
    $description = $_POST["description"];

    $stmt = $db->prepare("UPDATE ads SET images=:images, title=:title, description=:description WHERE id=:id");
    $stmt->bindValue(':images', $images, SQLITE3_TEXT);
    $stmt->bindValue(':title', $title, SQLITE3_TEXT);
    $stmt->bindValue(':description', $description, SQLITE3_TEXT);
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $result = $stmt->execute();

    if (!$result) {
        die("Database query error: " . $db->lastErrorMsg());
    }

    header("Location: ads.php");
    exit();
}

include "includes/header.php";
?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ Main Content ] start -->
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white"><i class="fas fa-images" style="font-size:20px">&nbsp;&nbsp;</i>Edit Advert</h4>
                                    </div>
                                    <div class="card-body">
                                        <form method="post">
                                            <div class="form-group">
                                                <input type="hidden" name="id" value="<?php echo $row["id"]; ?>">
                                            </div>
                                            <div class="form-group">
                                                <label class="bmd-label-floating"><strong>Image Url</strong></label>
                                                <input type="url" class="form-control text-primary" name="images" value="<?php echo $row["images"]; ?>" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="bmd-label-floating"><strong>Title</strong></label>
                                                <input type="text" class="form-control text-primary" name="title" value="<?php echo $row["title"]; ?>" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="bmd-label-floating"><strong>Description</strong></label>
                                                <textarea class="form-control text-primary" name="description" rows="4" required><?php echo $row["description"]; ?></textarea>
                                            </div>
                                            <div align="center" class="form-group mb-3">
                                                <br>
                                                <button class="btn btn-danger btn-icon-split" name="submit" type="submit">
                                                    <span class="icon text-white-50"><i class="fas fa-save"></i>&nbsp;&nbsp;</span>
                                                    <span class="text"> Save Settings</span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Column -->
                        </div>
                    </div>
                    <!-- ============================================================== -->
                    <!-- End Container fluid  -->
                    <!-- ============================================================== -->
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Page wrapper  -->
            <!-- ============================================================== -->
        </div>
    </div>
</div>

<?php
include "includes/functions.php";
?>
