<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Raleway:700">
<style>
  *,
  *:before,
  *:after {
    box-sizing: border-box;
  }
  html {
    height: 100%;
  }
  body {
    font-family: 'Raleway', sans-serif;
    background: linear-gradient(to bottom, #1a1a1a, #333333);
    height: 100%;
    padding: 10px;
    color: #ffffff;
  }
  a {
    color: #1FA9D6 !important;
    text-decoration: none;
  }
  a:hover {
    color: #FFFFFF !important;
    text-decoration: underline;
  }
  .text-wrapper {
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
  }
  .title {
    font-size: 5em;
    font-weight: 700;
    color: #1FA9D6;
  }
  .subtitle {
    font-size: 40px;
    font-weight: 700;
    color: #ffffff;
  }
  .isi {
    font-size: 18px;
    text-align: center;
    margin: 30px;
    padding: 20px;
    background: linear-gradient(to bottom, #333333, #1a1a1a);
    border-radius: 10px;
  }
  .buttons {
    margin: 30px;
    font-weight: 700;
    border: 2px solid #1FA9D6;
    text-decoration: none;
    padding: 15px 30px;
    text-transform: uppercase;
    color: #1FA9D6;
    border-radius: 26px;
    transition: all 0.2s ease-in-out;
    display: inline-block;
    background: linear-gradient(to bottom, #1FA9D6, #005f80);
  }
  .buttons:hover {
    background: linear-gradient(to bottom, #005f80, #1FA9D6);
    color: white;
    transition: all 0.2s ease-in-out;
  }
</style>
</head>
<body>
<div class="text-wrapper">
  <div class="title" data-content="404">
    403 - ACCESS DENIED
  </div>
  <div class="subtitle">
    Oops, You don't have permission to access this page.
  </div>
  <div class="isi">
    Ready to take the next step? Contact us today to discuss your project and learn how we can turn your vision into reality. Don't hesitate to <a href="https://t.me/apkrebrandec" target="_blank">reach out to us on Telegram</a>. Your digital transformation journey starts here.
  </div>
  <div class="buttons">
    <a class="button" href="https://t.me/apkrebrandec">Telegram Store</a>
  </div>
</div>
</body>
</html>
